<?php
/**
 * Plugin Name: LearnDo Reports
 * Plugin URI: https://albrightdesign.de
 * Description: Collect, display and export reports for learndo
 * Version: 4.0.1
 * Author: Benjamin Albrecht
 * Author URI: https://albrightdesign.de
 * Require_LP_Version: 3.0.0
 * License: 
 */
 
/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

define( 'LP_ADDON_LEARNDOREPORTS_FILE', __FILE__ );

/**
 * Class LP_Addon_LearndoReports_Preload
 */
class LP_Addon_LearndoReports_Preload {
	/**s
	 * @var array|string[]
	 */
	public static $addon_info = array();

	/**
	 * LP_Addon_LearndoReports_Preload constructor.
	 */
	public function __construct() {
		// Set Base name plugin.
		define( 'LP_ADDON_LEARNDOREPORTS_BASENAME', plugin_basename( LP_ADDON_LEARNDOREPORTS_FILE ) );

		// Set version addon for LP check .
		include_once ABSPATH . 'wp-admin/includes/plugin.php';
		self::$addon_info = get_file_data(
			LP_ADDON_LEARNDOREPORTS_FILE,
			array(
				'Name'               => 'Plugin Name',
				'Require_LP_Version' => 'Require_LP_Version',
				'Version'            => 'Version',
			)
		);

		define( 'LP_ADDON_LEARNDOREPORTS_VER', self::$addon_info['Version'] );
		define( 'LP_ADDON_LEARNDOREPORTS_REQUIRE_VER', self::$addon_info['Require_LP_Version'] );

		// Check LP activated .
		if ( ! is_plugin_active( 'learnpress/learnpress.php' ) ) {
			add_action( 'admin_notices', array( $this, 'show_note_errors_require_lp' ) );

			deactivate_plugins( LP_ADDON_LEARNDOREPORTS_BASENAME );

			if ( isset( $_GET['activate'] ) ) {
				unset( $_GET['activate'] );
			}

			return;
		}

		// Sure LP loaded.
		add_action( 'learn-press/ready', array( $this, 'load' ) );
	}

	/**
	 * Load addon
	 */
	public function load() {
		LP_Addon::load( 'LP_Addon_LearndoReports', 'inc/load.php', __FILE__ );
	}

	public function show_note_errors_require_lp() {
		?>
		<div class="notice notice-error">
			<p><?php echo( 'Please active <strong>LP version ' . LP_ADDON_LEARNDOREPORTS_REQUIRE_VER . ' or later</strong> before active <strong>' . self::$addon_info['Name'] . '</strong>' ); ?></p>
		</div>
		<?php
	}

}

new LP_Addon_LearndoReports_Preload();



// create a new database to track users course interactions
register_activation_hook( __FILE__, 'learndo_reports_activation_hook' );

function learndo_reports_activation_hook(){
	learn_press_learndo_reports_create_db();
	learn_press_learndo_reports_downloadables_create_db();
}

function learn_press_learndo_reports_create_db() {
	global $wpdb;
	$charset_collate = $wpdb->get_charset_collate();
	$table_name = $wpdb->prefix . 'learnpress_course_tracking';

	$sql = "CREATE TABLE $table_name (
		id bigint(20) NOT NULL AUTO_INCREMENT,
		time datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
		course_id bigint(20) NOT NULL,
		user_id bigint(20) NOT NULL,
		graduation varchar(45) NULL,
		is_member smallint(1) NULL,
		percent_completed bigint(20) NULL,
		UNIQUE KEY id (id)
	) $charset_collate;";

	require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
	dbDelta( $sql );
}

// create a new database to track users downloadables interactions
register_activation_hook( __FILE__, 'learn_press_learndo_reports_downloadables_create_db' );
function learn_press_learndo_reports_downloadables_create_db() {
	global $wpdb;
	$charset_collate = $wpdb->get_charset_collate();
	$table_name = $wpdb->prefix . 'learnpress_downloadables_tracking';

	$sql = "CREATE TABLE $table_name (
		id bigint(20) NOT NULL AUTO_INCREMENT,
		time datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
		product_id bigint(20) NOT NULL,
		download_id bigint(20) NOT NULL,
		user_id bigint(20) NOT NULL,
		is_member smallint(1) NULL,
		action varchar(45) DEFAULT 'download',
		location varchar(45) NULL,
		UNIQUE KEY id (id)
	) $charset_collate;";

	require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
	dbDelta( $sql );
}
