<?php
/**
 * Plugin load class.
 *
 * @author   ThimPress
 * @package  LearnPress/LearndoReports/Classes
 * @version  4.0.0
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;
if ( ! class_exists( 'LP_Addon_LearndoReports' ) ) {
	/**
	 * Class LP_Addon_LearndoReports.
	 */
	class LP_Addon_LearndoReports extends LP_Addon {

		/**
		 * @var string
		 */
		protected $_tab_slug_District = '';


		/**
		 * @var string
		 */
		public $version = LP_ADDON_LEARNDOREPORTS_VER;

		/**
		 * @var string
		 */
		public $require_version = LP_ADDON_LEARNDOREPORTS_REQUIRE_VER;

		/**
		 * Path file addon
		 *
		 * @var string
		 */
		public $plugin_file = LP_ADDON_LEARNDOREPORTS_FILE;

		/**
		 * LP_Addon_Wishlist constructor.
		 */
		public function __construct() {
			parent::__construct();
			//add_filter( 'learn-press/profile-tabs', array( $this, 'District_tab' ), 101, 1 );
			//$this->_tab_slug_District = sanitize_title( __( 'District', 'learnpress-district' ) );
			
			add_action( 'widgets_init', array( $this, 'load_widget' ) );
		}

		/**
		 * Defined constants.
		 */
		protected function _define_constants() {
			define( 'LP_ADDON_LEARNDOREPORTS_PATH', dirname( LP_ADDON_LEARNDOREPORTS_FILE ) );
			define( 'LP_ADDON_LEARNDOREPORTS_INC', LP_ADDON_LEARNDOREPORTS_PATH . '/inc/' );
			define( 'LP_ADDON_LEARNDOREPORTS_TEMPLATE', LP_ADDON_LEARNDOREPORTS_PATH . '/templates/' );
		}

		/**
		 * Includes files.
		 */
		protected function _includes() {
			include_once LP_ADDON_LEARNDOREPORTS_INC . 'admin/page-overview.php';
			include_once LP_ADDON_LEARNDOREPORTS_INC . 'admin/page-courses.php';
			include_once LP_ADDON_LEARNDOREPORTS_INC . 'admin/page-downloadables.php';

			include_once LP_ADDON_LEARNDOREPORTS_INC . 'data/track-course-data.php';
			include_once LP_ADDON_LEARNDOREPORTS_INC . 'data/track-downloadables-data.php';

			// dsitrict reports
			include_once LP_ADDON_LEARNDOREPORTS_INC . 'admin/page-district-team.php';


			include_once LP_ADDON_LEARNDOREPORTS_INC . 'functions.php';
			require_once LP_ADDON_LEARNDOREPORTS_INC . 'widgets.php';


		}

		/**
		 * Init hooks.
		 */
		protected function _init_hooks() {
			//$this->rewrite_endpoint();
		}


		/**
		 * Wishlist scripts.
		 */
		protected function _enqueue_assets() {
		}

		/**
		 * Rewrite endpoint.
		 */
		public function rewrite_endpoint() {
			//$endpoint                     = preg_replace( '!_!', '-', $this->get_District_tab_slug() );
			//LP()->query_vars[ $endpoint ] = $endpoint;
			//add_rewrite_endpoint( $endpoint, EP_ROOT | EP_PAGES );
		}

		public function profile_tab_endpoints( $endpoints ) {
			//$endpoints[] = $this->get_District_tab_slug();

			return $endpoints;
		}



		 public function load_widget() {
			//register_widget( 'LP_Widget_Pricing_Link' );
		}


	}
}

add_action( 'plugins_loaded', array( 'LP_Addon_LearndoReports', 'instance' ) );
