<?php // content="text/plain; charset=utf-8"

$from = $_GET["from"];
$to = $_GET["to"];
$values = $_GET["values"];
$legends = $_GET["legends"];

$fileName =  __DIR__. "/export/" . $_GET["filename"];
  
require_once ('../../lib/jpgraph/src/jpgraph.php');
require_once ('../../lib/jpgraph/src/jpgraph_line.php');

$datay1=array();
$titles=array('JAN', 'FEB','MAR', 'APR', 'MAY', 'JUN', 'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC');
foreach($values as $key => $value){
  $datay1 = $values[0];
  $datay2 = $values[1];
  //$titles[] = $key;
}

// Create the graph. These two calls are always required
$graph = new Graph(1400,700,'auto');
$graph->SetScale('textint');

$theme_class=new UniversalTheme;

$graph->SetTheme($theme_class);
$graph->img->SetAntiAliasing(false);

//$graph->yaxis->SetTickPositions(array(0,30,60,90,120,150), array(15,45,75,105,135));
$graph->SetBox(false);

$graph->title->SetFont(FF_SANCHEZ,FS_NORMAL,0);
$graph->title->SetMargin(0);
$graph->SetMargin(40,20,60,150);

$graph->ygrid->SetFill(false);
$graph->yaxis->SetFont(FF_BEBAS,FS_NORMAL,20);
$graph->xaxis->SetTickLabels($titles);
$graph->yaxis->HideLine(true);
$graph->yaxis->HideTicks(true,true);
$graph->xaxis->SetFont(FF_BEBAS,FS_NORMAL,20);
$graph->xaxis->SetLabelMargin(20);



// Create the bar plots
$p1 = new LinePlot($values[0]);
$graph->Add($p1);

$p2 = new LinePlot($values[1]);
$graph->Add($p2);

$p3 = new LinePlot($values[2]);
$graph->Add($p3);

$p4 = new LinePlot($values[3]);
$graph->Add($p4);

$p5 = new LinePlot($values[4]);
$graph->Add($p5);

$p1->SetColor("#197886");
$p1->SetLegend($legends[0]);
$p1->SetWeight(7);
$p1->SetStyle("solid");
$p1->mark->SetType(MARK_FILLEDCIRCLE,'',1.0);
$p1->mark->SetColor('#197886');
$p1->mark->SetSize(10);
$p1->mark->SetFillColor('#197886');
$p2->value->SetMargin(14);
$p1->SetCenter();

$colours = [ '#b0d7a4', '#b4d43b', '#197886', '#a4c9d7', '#ff2768', '#09d2fb'  ];

$p2->SetColor("#b0d7a4");
$p2->SetLegend($legends[1]);
$p2->SetWeight(7);
$p2->mark->SetType(MARK_FILLEDCIRCLE,'',10.0);
$p2->mark->SetColor('#b0d7a4');
$p2->mark->SetFillColor('#b0d7a4');
$p2->mark->SetSize(10);
$p2->value->SetMargin(14);
$p2->SetCenter();

$p3->SetColor("#09d2fb");
$p3->SetLegend($legends[2]);
$p3->SetWeight(7);
$p3->mark->SetType(MARK_FILLEDCIRCLE,'',10.0);
$p3->mark->SetColor('#09d2fb');
$p3->mark->SetFillColor('#09d2fb');
$p3->mark->SetSize(10);
$p3->value->SetMargin(14);
$p3->SetCenter();

$p4->SetColor("#a4c9d7");
$p4->SetLegend($legends[3]);
$p4->SetWeight(7);
$p4->mark->SetType(MARK_FILLEDCIRCLE,'',10.0);
$p4->mark->SetColor('#a4c9d7');
$p4->mark->SetFillColor('#a4c9d7');
$p4->mark->SetSize(10);
$p4->value->SetMargin(14);
$p4->SetCenter();

$p5->SetColor("#ff2768");
$p5->SetLegend($legends[4]);
$p5->SetWeight(7);
$p5->mark->SetType(MARK_FILLEDCIRCLE,'',10.0);
$p5->mark->SetColor('#ff2768');
$p5->mark->SetFillColor('#ff2768');
$p5->mark->SetSize(10);
$p5->value->SetMargin(14);
$p5->SetCenter();

$graph->legend->SetFrameWeight(200); 
$graph->legend->SetHColMargin(50); 
$graph->legend->SetPos(0.02,0.98,'left','bottom');
$graph->legend->SetFrameWeight(0);
$graph->legend->SetColor('#4E4E4E','#00A78A');
$graph->legend->SetMarkAbsSize(20);
$graph->legend->SetFont(FF_SANCHEZ,FS_NORMAL,20);

// Display the graph
//$graph->Stroke();


$gdImgHandler = $graph->Stroke(_IMG_HANDLER);
 
// Stroke image to a file and browser
 
// Default is PNG so use ".png" as suffix
$graph->img->SetAntiAliasing(false);

$graph->img->Stream($fileName);
 
// Send it back to browser
$graph->img->Headers();
$graph->img->Stream();

?>
