<?php

    function getOverviewData($from, $to){
		global $wpdb; //This is used only if making any database queries

		$args = array (
			'date_query'    => array(
				array(
					'after'     => $from,
					'before'     => $to,
					'inclusive' => true,
				),
			 ),
		);
		
		$user_query = new WP_User_Query( $args );

		// Get paying customers
		$paying_customers = $wpdb->get_results("
			SELECT p.ID, p.post_type as type, p.post_date as date, t.meta_value as total, u.meta_value as user, cu.meta_value as cuser
			FROM `wp_posts` as p
			LEFT JOIN wp_postmeta AS t
			ON p.ID = t.post_id AND t.meta_key = '_order_total' 
			LEFT JOIN wp_postmeta AS u
			ON p.ID = u.post_id AND u.meta_key = '_user_id' 
			LEFT JOIN wp_postmeta AS cu
			ON p.ID = cu.post_id AND cu.meta_key = '_customer_user' 
			
			WHERE p.post_type = 'shop_order' 
			AND p.post_status = 'wc-completed'
			AND t.meta_value > 0
			AND p.post_date between '$from' and '$to'
			;");
			/* OR 
			p.post_type = 'lp_order'
			AND p.post_status = 'lp-completed'
			AND t.meta_value > 0
			AND p.post_date between '$from' and '$to'
			GROUP BY  cu.meta_value, u.meta_value;
		"); */

	$paying_customers_totals = $wpdb->get_results("
		SELECT p.ID, p.post_type as type, p.post_date as date, t.meta_value as total, u.meta_value as user, cu.meta_value as cuser
		FROM `wp_posts` as p
		LEFT JOIN wp_postmeta AS t
		ON p.ID = t.post_id AND t.meta_key = '_order_total' 
		LEFT JOIN wp_postmeta AS u
		ON p.ID = u.post_id AND u.meta_key = '_user_id' 
		LEFT JOIN wp_postmeta AS cu
		ON p.ID = cu.post_id AND cu.meta_key = '_customer_user' 


		WHERE p.post_type = 'shop_order' 
		AND p.post_status = 'wc-completed'
		AND t.meta_value > 0
		AND p.post_date between '$from' and '$to'
		;");
		/* OR 
		p.post_type = 'lp_order'
		AND p.post_status = 'lp-completed'
		AND t.meta_value > 0
		AND p.post_date between '$from' and '$to'
		#GROUP BY  cu.meta_value, u.meta_value;
	"); */

		// Todo remove that
		$revenue_paing = 0;
		foreach($paying_customers_totals as $customer){
			$revenue_paing += $customer->total;
			//echo $customer->amount . "<br>";
		}
		$avarage_per_user = 0;
		if(count($paying_customers) > 0){
			$avarage_per_user = $revenue_paing/count($paying_customers);
		}

		// Get subscribers
		$subscribers = $wpdb->get_results("
			SELECT * FROM wp_pmpro_memberships_users
			WHERE status LIKE 'active'
			AND cycle_number = 0
			#AND billing_amount > 0
			AND startdate BETWEEN '$from' and '$to'
		");
		$revenue_subscribers = 0;
		foreach($subscribers as $subscriber){
			$revenue_subscribers += $subscriber->billing_amount;
		}
		$avarage_per_subscriber = 0;
		if(count($subscribers) > 0){
			$avarage_per_subscriber = $revenue_subscribers/count($subscribers);
		}

		// Get Renewals subscribers
		$renewals = $wpdb->get_results("
		SELECT * FROM wp_pmpro_memberships_users
		WHERE status LIKE 'active'
		AND cycle_number > 0
		#AND billing_amount > 0
		AND startdate BETWEEN '$from' and '$to'
		");
		$revenue_renewals = 0;
		foreach($renewals as $renewal){
			$revenue_renewals += $renewal->billing_amount;
		}
		$avarage_per_renewal = 0;
		if(count($renewals) > 0){
			$avarage_per_renewal = $revenue_renewals/count($renewals);
		}

		// Get Woocomerce Downloadables
		/* $products = $wpdb->get_results("
			SELECT p.post_title as product, pm.meta_value as total_sales 
			FROM wp_posts AS p 
			LEFT JOIN wp_postmeta AS pm ON (p.ID = pm.post_id AND pm.meta_key LIKE 'total_sales') 
			WHERE p.post_type LIKE 'product' 
			AND p.post_status LIKE 'publish'
		");
		$orders = wc_get_orders(array(
			'limit' => -1,
			'type' => 'shop_order',
			'status' => 'completed',
			'date_created'=> $from .'...'. $to 
			)
		);
		$downloadables_count = 0;
		$downloadables_amount = 0;
		$downloadables_order_count = 0;
		$downloadables_avarage = 0;

		foreach($orders as $order){
			$order_data = $order->get_data();
			$order_id = $order_data['id'];

			if($order->get_total() > 0){
				//echo $order->get_total() . '<br>';
				$order_has_downloadables = false;
				foreach ( $order->get_items() as $item_id => $item ) {
					if(!$item->get_meta('_course_id')) {
						//echo $item->get_name() . '<br>';
						//echo var_dump($item->get_meta_data()) . '<br>';
						//echo $item->get_meta('_course_id') . '<br>';
						//echo $item->get_total() . '<br>';
						$downloadables_count += $item->get_quantity();
						$downloadables_amount += $item->get_total();
						$order_has_downloadables = true;
					}
				}
				if($order_has_downloadables) {
					$downloadables_order_count++;
				}
				//echo '<hr />';
			}
		}
 */



		$downloadable_sales = $wpdb->get_results("
		SELECT o.ID as order_id, o.post_date, woot.meta_value AS order_total, 
		items.order_item_name AS name, items.order_item_id,
		p.meta_value as product_id, itotal.meta_value+itax.meta_value as item_total
		FROM `wp_posts` AS o
				LEFT JOIN wp_postmeta AS woot
				ON o.ID = woot.post_id AND woot.meta_key = '_order_total'
		
				JOIN wp_woocommerce_order_items AS items
				ON o.ID = items.order_id AND items.order_item_type = 'line_item'
		
				LEFT JOIN wp_woocommerce_order_itemmeta as p
				ON items.order_item_id = p.order_item_id AND p.meta_key = '_product_id'
		
				LEFT JOIN wp_woocommerce_order_itemmeta as itotal
				ON items.order_item_id = itotal.order_item_id AND itotal.meta_key = '_line_total'
		
				LEFT JOIN wp_woocommerce_order_itemmeta as itax
				ON items.order_item_id = itax.order_item_id AND itax.meta_key = '_line_tax'
		
		WHERE o.post_type = 'shop_order'
		AND o.post_status = 'wc-completed'
		AND woot.meta_value > 0
		AND p.meta_value > 0
		AND o.post_date between '$from' and '$to';
		");

		$downloadables_amount = 0;

		foreach($downloadable_sales as $dsale){
			$downloadables_amount += $dsale->item_total;
		}

		$downloadables_count = count($downloadable_sales);
		$downloadables_order_count = count($downloadable_sales);
		$downloadables_avarage = 0;

		if($downloadables_order_count > 0 && $downloadables_amount > 0) {
			$downloadables_avarage = $downloadables_amount / $downloadables_order_count;
		}

		// coursee new
		$course_purchases = $wpdb->get_results("
		SELECT  o.order_item_name AS name, o.item_id, wco.post_date AS date, o.order_id AS order_id, woo.meta_value AS woo_id,  total.meta_value AS sub_total, woot.meta_value AS total
		FROM `wp_learnpress_order_items` AS o

		LEFT JOIN wp_learnpress_order_itemmeta AS total
		ON o.order_item_id = total.learnpress_order_item_id AND total.meta_key = '_total'

		LEFT JOIN wp_posts AS wco
		ON o.order_id = wco.ID AND wco.post_status = 'lp-completed'

		LEFT JOIN wp_postmeta AS woo
		ON o.order_id = woo.post_id AND woo.meta_key =  '_woo_order_id'

		LEFT JOIN wp_postmeta AS woot
		ON woo.meta_value = woot.post_id AND woot.meta_key = '_order_total'

		WHERE woot.meta_value > 0
		AND wco.post_date between '$from' and '$to'
		;");

		$courses_amount = 0;
		$courses_order_count = count($course_purchases);
		foreach($course_purchases as $purchase){
			$courses_amount += $purchase->total;
		}
		$courses_avarage = 0;
		if($courses_order_count > 0 && $courses_amount > 0) {
			$courses_avarage = $courses_amount / $courses_order_count;
		}

		// calc revenue paying customers
		//$revenue_paing = $revenue_subscribers + $downloadables_amount + $courses_amount;
		$avarage_per_user = 0;
		if(count($paying_customers) > 0){
			$avarage_per_user = $revenue_paing/count($paying_customers);
		}


        $items = [

			[ 
				"title" => "Account Signups",
			 	"count" => count($user_query->get_results()),
				"avarage_per_user" => "",
				"revenue" => ""
			],
			[ 
				"title" => "Paid Users",
			 	"count" => count($paying_customers),
				"avarage_per_user" => wc_price($avarage_per_user),
				"revenue" => wc_price($revenue_paing)
			],
			[ 
				"title" => "Subscribers",
			 	"count" => count($subscribers),
				"avarage_per_user" => wc_price($avarage_per_subscriber),
				"revenue" => wc_price($revenue_subscribers)
			],
			[ 
				"title" => "Renewals",
			 	"count" => count($renewals),
				"avarage_per_user" => wc_price($avarage_per_renewal),
				"revenue" => wc_price($revenue_renewals)
			],
			[ 
				"title" => "Tools and Downloadables Purchased",
			 	"count" => $downloadables_count,
				"avarage_per_user" => wc_price($downloadables_avarage),
				"revenue" => wc_price($downloadables_amount)
			],
			[ 
				"title" => "Courses Purchased",
			 	"count" => $courses_order_count,
				"avarage_per_user" => wc_price($courses_avarage),
				"revenue" => wc_price($courses_amount)
			],
			[ 
				"title" => "<b>Total</b>",
			 	"count" => "",
				"avarage_per_user" => "",
				"revenue" => '<b>' . wc_price($revenue_subscribers + $downloadables_amount + $courses_amount) . '</b>'
			],
		];

        return $items;

    }


?>