<?php
/**
 * LearnPress Admin Page Overview
 *
 * Define common functions for both front-end and back-end
 *
 * @author   ThimPress
 * @package  LearnPress/Wishlist/Functions
 * @version  3.0.0
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;

require_once  LP_ADDON_LEARNDOREPORTS_INC . 'data/data-overview.php';



if (!class_exists('WP_List_Table')) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

function learndo_reports_add_menu_item_overview() {
    add_menu_page('LearnDo Reports', 'LearnDo Reports', 'activate_plugins', 'learndo-reports', 'learndo_reports_render_overview', 'dashicons-chart-bar', 4);
}

add_action('admin_menu', 'learndo_reports_add_menu_item_overview');

function learndo_reports_render_overview() { ?>
	<?php 

		$from = array_key_exists('from_date', $_GET) ? $_GET['from_date'] : '';
		$to = array_key_exists('to_date', $_GET) ? $_GET['to_date'] : date('Y-m-d');

	?>

	<?php
    //Create an instance of our package class...
    $overviewTable = new LearnDo_Reports_Overview_Table();
    //Fetch, prepare, sort, and filter our data...
    $overviewTable->prepare_items();
    ?>
    <div class="wrap">

        <div id="icon-users" class="icon32"><br/></div>
        <h2>LearnDo Reports - Overview</h2>

		<form action="<?= esc_url(admin_url('admin.php')) ?>">
			<input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />
			<input type="date" name="from_date" value="<?= $from ?>" />
			<input type="date" name="to_date" value="<?= $to ?>" />
			<input type="submit" value="Show" class="e-button" />

			<a href="<?= esc_url(admin_url('admin.php')) . "?page=" .  $_REQUEST['page'] . "&from_date=&to_date=" . date('Y-m-d') ?>" class="button">All Time</a>
			<a href="<?= esc_url(admin_url('admin.php')) . "?page=" .  $_REQUEST['page'] . "&from_date=" . date("Y-m-d", mktime(0, 0, 0, date("m")-1, 1)) . "&to_date=" . date("Y-m-d", mktime(0, 0, 0, date("m"), 0)) ?>" class="button">Last Month</a>
			<a href="<?= esc_url(admin_url('admin.php')) . "?page=" .  $_REQUEST['page'] . "&from_date=" . date("Y-m-d", mktime(0, 0, 0, date("m"), 1)) . "&to_date=" . date('Y-m-d') ?>" class="button">Current Month</a>



		<?php
		$values = array();
		foreach($overviewTable->items as $item){
			$title = $item["title"];
			if($title == "Tools and Downloadables Purchased"){
				$title = "Tools &
Downloadables";
			}
			if($title == "Account Signups"){
				$title = "Account
Signups";
			}
			if($title == "Courses Purchased"){
				$title = "Courses";
			}
			
			if($title != "<b>Total</b>")
			$values[$title] = intval($item["count"]) ;
		} 
		/* ?> <pre> <?php var_dump($values); ?> </pre> <?php */
		$file_name = "overview_$from-$to.png";
		$queries = array(
			"from" => $from,
			"to"	=> $to,
			"values" => $values,
            "filename" => $file_name
		);
		
		$queryString = http_build_query($queries);
        $graph_url = plugin_dir_url( __FILE__ ) . "../graphs/bar_graph.php?" . $queryString;
        $graph_href =plugin_dir_url( dirname( dirname(__FILE__) )) . "/inc/graphs/export/" . $file_name; 

		?>
<?php if($from == ""):
        //$monthly_dates = [];
        $values = array();
        $legends = array();
        for($i = 1; $i <= 12; $i++){
            $from_m = date("Y-m-d", mktime(0, 0, 1, $i, 1));
            $to_m = date("Y-m-d", mktime(0, 0, 1, $i+1, 0));
            //echo $from_m . ' - ' .  $to_m;
            $data_m = getOverviewData($from_m,$to_m);

            foreach ($data_m as $key => $v) {
                //echo $v["title"] . ': ' . $v["count"] . '<br>';
                if($v["title"] == 'Account Signups'){
                    $values[1][$i-1] = intval($v["count"]);
                    $legends[1] = $v["title"];
                }
                if($v["title"] == 'Subscribers'){
                    $values[0][$i-1] = intval($v["count"]);
                    $legends[0] = $v["title"];
                }
                if($v["title"] == 'Renewals'){
                    $values[3][$i-1] = intval($v["count"]);
                    $legends[3] = $v["title"];
                }
                if($v["title"] == 'Tools and Downloadables Purchased'){
                    $values[4][$i-1] = intval($v["count"]);
                    $legends[4] = $v["title"];
                }
                if($v["title"] == 'Courses Purchased'){
                    $values[2][$i-1] = intval($v["count"]);
                    $legends[2] = $v["title"];
                }
            }
            
        }

         /* ?> <pre> <?php var_dump($values); ?> </pre> <?php */

        //getOverviewData($from,$to);
        
        $file_name_monthly = "overview_monthly.png";
		$queries = array(
			"from" => $from,
			"to"	=> $to,
			"values" => $values,
            "filename" => $file_name_monthly,
            "legends" => $legends
		);
        $queryString = http_build_query($queries);
        $graph_line_url = plugin_dir_url( __FILE__ ) . "../graphs/line_graph.php?" . $queryString;
        $graph_monthly_href = plugin_dir_url( dirname( dirname(__FILE__) )) . "/inc/graphs/export/" . $file_name_monthly;


        ?>
        <a class="button alignright"  href="<?=  plugin_dir_url( __FILE__ ) . "../pdf/pdf-overview.php?img1=". $graph_href . "&img2=". $graph_monthly_href . "&from=$from&to=$to" ?>" target="_blank">PDF download</a>

<?php else: ?>
            <a class="button alignright" href="<?=  plugin_dir_url( __FILE__ ) . "../pdf/pdf-overview.php?img1=". $graph_href . "&from=$from&to=$to" ?>" target="_blank">PDF download</a>

<?php endif; ?> 

<?php // Create CSV
        $csv_href = plugin_dir_url( dirname( dirname(__FILE__) )) . "/inc/csv/overview.csv";
        $f = fopen(LP_ADDON_LEARNDOREPORTS_INC. "/csv/overview.csv", "wa+"); 
        fputcsv($f, str_replace("title","$from - $to", array_keys($overviewTable->items[0])));
        foreach ($overviewTable->items as $row)
        {
            fputcsv($f, array_map("html_entity_decode",preg_replace("/<.+>/sU", "", $row)));
        }
        fclose($f);
        ?><a class="button alignright"  href="<?= $csv_href ?>" target="_blank">CSV download</a> 
</form>

		<img src="<?php echo  $graph_url  ?>" style="width:100%; max-width: 900px" />

        <?php

if($from == ""): ?>
        <img src="<?php echo  $graph_line_url  ?>" style="width:100%; max-width: 900px" />
<?php endif; ?>        

        <!-- Forms are NOT created automatically, so you need to wrap the table in one to use features like bulk actions -->
        <form id="movies-filter" method="get">
            <!-- For plugins, we also need to ensure that the form posts back to our current page -->
            <input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />
            <!-- Now we can render the completed list table -->
   
			<?php $overviewTable->display() ?>
        </form>

    </div>
    <?php }

class LearnDo_Reports_Overview_Table extends WP_List_Table {

    function __construct() {
        global $status, $page;

        //Set parent defaults
        parent::__construct(array(
            'singular' => 'Nice Link', //singular name of the listed records
            'plural' => 'Nice Links', //plural name of the listed records
            'ajax' => false        //does this table support ajax?
        ));
    }

    function column_default($item, $column_name) {
        switch ($column_name) {
            case 'title': return "<div style='text-align: right'>" . $item["title"] . "</div>";
            case 'count': return $item["count"];
			case 'avarage_per_user': return $item["avarage_per_user"];
			case 'revenue': return $item["revenue"];
            default:
                return "col name = $column_name , " . print_r($item, true); //Show the whole array for troubleshooting purposes
        }
    }

    function get_columns() {
        return $columns = array(
            'title' => '',
            'count' => __('Count'),
            'avarage_per_user' => __('Avarage spend per user'),
            'revenue' => __('Revenue')
        );
    }
  
    function prepare_items() {
		$columns = $this->get_columns();
        $hidden = array();
        $sortable = array();

        $this->_column_headers = array($columns, $hidden, $sortable);

		$from = array_key_exists('from_date', $_GET) ? $_GET['from_date'] : '';
		$to = array_key_exists('to_date', $_GET) ? $_GET['to_date'] : date('Y-m-d');

		$this->items = getOverviewData($from,$to);
    }

}

?>