<?php
/**
 * LearnPress Admin Page Overview
 *
 * Define common functions for both front-end and back-end
 *
 * @author   ThimPress
 * @package  LearnPress/Wishlist/Functions
 * @version  3.0.0
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;

require_once  LP_ADDON_LEARNDOREPORTS_INC . 'data/data-team.php';
require_once  LP_ADDON_LEARNDOREPORTS_INC . 'data/data-team-reports.php';

$district_plugin = WP_PLUGIN_DIR . '/learnpress-district';
if ( is_dir( $district_plugin ) ) {
    // plugin directory found!
    require_once $district_plugin . '/inc/mail/send_reports.php';

}



if (!class_exists('WP_List_Table')) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

function learndo_reports_add_menu_item_district_team_reports() {
	add_submenu_page('learndo-district', 'Team Reports', 'Team Reports', 'activate_plugins', 'learndo-reports-district-team', 'learndo_reports_render_district_team', 2);
}
add_action('admin_menu', 'learndo_reports_add_menu_item_district_team_reports');


function learndo_reports_render_district_team() {
	?>
	

		<div class="wrap">
	
			<div id="icon-users" class="icon32"><br/></div>
			<h2>LearnDo Reports - Team</h2>
			
			<form id="form_district" action="<?= esc_url(admin_url('admin.php')) ?>">
				<input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />


                <?php
                    $districts = get_posts([
                        'post_type' => 'learnpress_district',
                        'numberposts' => -1,
                         'order'    => 'ASC'
                    ]);
                    $district_id = array_key_exists('district', $_GET) ? $_GET['district'] :  $districts[0]->ID;

                ?>
                <label for="district">District: </label>
                <select name="district">
                    <?php foreach($districts as $district): ?>
                        <option
                        <?php if($district->ID == $district_id):?> selected="selected" <?php endif?>
                        value="<?= $district->ID?> "><?= $district->post_title  ?></option>
                    <?php endforeach ?>
                </select>

                <?php /*
				<a href="<?= esc_url(admin_url('admin.php')) . "?page=" .  $_REQUEST['page'] . "&from_date=&to_date=" . date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+1 )) ?>" class="button">All Time</a>
				<a href="<?= esc_url(admin_url('admin.php')) . "?page=" .  $_REQUEST['page'] . "&from_date=" . date("Y-m-d", mktime(0, 0, 0, date("m")-1, 1)) . "&to_date=" . date("Y-m-d", mktime(0, 0, 0, date("m"), 0)) ?>" class="button">Last Month</a>
				<a href="<?= esc_url(admin_url('admin.php')) . "?page=" .  $_REQUEST['page'] . "&from_date=" . date("Y-m-d", mktime(0, 0, 0, date("m"), 1)) . "&to_date=" .  date("Y-m-d", mktime(0, 0, 0, date("m"), date("d")+1 )) ?>" class="button">Current Month</a>
                */ ?>

                <?php 
                $custom_range = array_key_exists('custom_range', $_GET) ? true : false;
                if($custom_range) {
                    $from = array_key_exists('from_date', $_GET) ? $_GET['from_date'] : '';
                    $to = array_key_exists('to_date', $_GET) ? $_GET['to_date'] : date('Y-m-d');
                    $quater = 99;
                    $year = null;
                } else {
                    $year = array_key_exists('year', $_GET) ? $_GET['year'] : date("Y");
                    if($year == "") $year = date("Y");
                    $quater_current = ceil(date("n") / 3);
                    $quater =  $quater_current - 1;
                    if($quater == 0){
                        $quater = 4;
                        $year = $year -1;
                    }
                    if(array_key_exists('quater', $_GET)){
                        $quater = $_GET['quater'] != "" ? $_GET['quater'] : $quater;
                    }
                    
                    $m = (($quater * 3)-3) + 1; // start month
                    $from = date("Y-m-d", mktime(0, 0, 1, $m, 1, $year));
                    $m = (($quater * 3)-3) + 3; // end month
                    $to = date("Y-m-d", mktime(0, 0, 1, $m, 1, $year));
                }
                $years = range(2022, date("Y"));
                ?>

                <select name="year">
                    <option value="">Select Year</option>
                    <?php foreach($years as $y) : ?>
                        <option <?php if($y == $year): ?> selected="selected" <?php endif ?>
                        value="<?php echo $y; ?>"><?php echo $y; ?></option>
                    <?php endforeach; ?>
                </select>
                <select name="quater">
                    <option value="">Select Quater</option>
                    <?php for ($i=1; $i <= 4; $i++): ?>
                        <option <?php if ($i == $quater): ?> selected="selected" <?php endif ?>
                        value="<?= $i ?>">Q<?= $i ?></option>
                    <?php endfor; ?>
                </select>

                <input type="submit" value="Show" class="e-button" />
				<a href="<?= esc_url(admin_url('admin.php')) . "?page=" .  $_REQUEST['page'] . "&district=" . $district_id ?>" class="button">Last Quater</a>


                <?php 
                /**
                 * CREATE THE REPORT
                 */
                $report = getDistrictReport($district_id, $quater, $year, $from, $to);
            ?>

            <?php /* <pre><?php var_dump($district_id);
            var_dump($report) ?></pre> */ ?>


<?php 

    $team_count = $report["member_graphs"]["team_count"];
    if($team_count == 0): ?>
        <h2><?php echo 'No team members assigned'; ?></h2>
    <?php else: 

	
    //Create an instance of our package class...
    $teamTable = new LearnDo_Reports_District_Team_Table();
    //Fetch, prepare, sort, and filter our data...
    $teamTable->prepare_items();
    ?>

            

        <a class="button alignright"  href="<?= $report["pdf"]["url"] ?>" target="_blank">PDF download</a>



				<?php // Create CSV
        $csv_href = plugin_dir_url( dirname( dirname(__FILE__) )) . "/inc/csv/team.csv";
        $f = fopen(LP_ADDON_LEARNDOREPORTS_INC . "/csv/team.csv", "wa+"); 
        fputcsv($f, array_keys($teamTable->items[0]));
        foreach ($teamTable->items as $row)
        {
            fputcsv($f, array_map("html_entity_decode",preg_replace("/<.+>/sU", "", $row)));
        }
        fclose($f);
        ?><a class="button alignright"  href="<?= $csv_href ?>" target="_blank">CSV download</a> 
        </form>

        <form id="form_custom_range" action="<?= esc_url(admin_url('admin.php')) ?>" style="margin: 15px 0">
				<label>Custom Range: </label>
                <input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />
                <input type="hidden" name="custom_range" value="true" />
                <input type="hidden"  name="district" value="<?= $district_id ?>" />
                <input type="date" name="from_date" value="<?= $from ?>" />
	            <input type="date" name="to_date" value="<?= $to ?>" />
                <input type="submit" value="Show Custom" class="e-button" />
			</form>
            
            <script type="text/javascript">
                document.querySelector("#form_custom_range").addEventListener("submit", function(e){
                    var formDataDistrict = new FormData(document.querySelector("#form_district"));
                    var district = formDataDistrict.get("district");
                    var formData = new FormData(e.target);
                    formData.set("district", district);
                    this.querySelector("input[name='district']").setAttribute("value", district);
                    //e.preventDefault();    //stop form from submitting
                });
            </script>

            <?php if($quater != 99): ?>
                <img src="<?php echo $report["team_graph"]  ?>" style="width:100%; max-width: 900px" />
            <?php endif ?>
            <?php foreach( $report["member_graphs"]["graphs"] as $member_graph ): ?>
                <img src="<?php echo  $member_graph  ?>" style="width:100%; max-width: 900px" />
            <?php endforeach ?>

			<!-- Forms are NOT created automatically, so you need to wrap the table in one to use features like bulk actions -->
			<form id="movies-filter" method="get">
				<!-- For plugins, we also need to ensure that the form posts back to our current page -->
				<input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />
				<!-- Now we can render the completed list table -->
		<?php $teamTable->display() ?>
			</form>
	
		</div>

        <?php if(array_key_exists('send_report_to', $_GET)): ?>
            <?php
                $send_report_to = $_REQUEST['send_report_to'];
                districtSendReport($send_report_to, $district_id, $report);
            ?>
            <script>
                const url = new URL(location);
                url.searchParams.delete('send_report_to');
                history.replaceState(null, null, url);
            </script>
            Report is send to <?= $send_report_to  ?>
        <?php else: ?>
        <form action="<?= esc_url(admin_url('admin.php')) ?>">
				<input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />
                <input type="hidden"  name="district" value="<?= $district_id ?>" />
                <input type="hidden"  name="quater" value="<?= $quater ?>" />
                <input type="hidden"  name="year" value="<?= $year ?>" />
                <input type="email" name="send_report_to" placeholder="send reports to" />
                <button class="button" type="submit">Send report</button>
        <?php endif ?>
    <?php endif ?>
		<?php }

class LearnDo_Reports_District_Team_Table extends WP_List_Table {


    function __construct() {
        global $status, $page;

        //Set parent defaults
        parent::__construct(array(
            'singular' => 'Nice Link', //singular name of the listed records
            'plural' => 'Nice Links', //plural name of the listed records
            'ajax' => false        //does this table support ajax?
        ));
    }

    function column_default($item, $column_name) {
        switch ($column_name) {
            case 'user': return "<b>" . $item["user"] . "</b>";
			case 'course_started': return $item["course_started"];
			case 'course_completed': return $item["course_completed"];
            case 'downloads': return $item["downloads"];
            default:
                return "col name = $column_name , " . print_r($item, true); //Show the whole array for troubleshooting purposes
        }
    }

    function get_columns() {
        return $columns = array(
            'user' => 'User',
            'course_started' => __('Courses Started'),
			'course_completed' => __('Courses Completed'),
            'downloads' => __('Tools and Resources Downloaded'),
        );
    }
  
	function prepare_items() {
        $custom_range = array_key_exists('custom_range', $_GET) ? true : false;
        if($custom_range) {
            $from = array_key_exists('from_date', $_GET) ? $_GET['from_date'] : '';
            $to = array_key_exists('to_date', $_GET) ? $_GET['to_date'] : date('Y-m-d');
        } else {
            $year = array_key_exists('year', $_GET) ? $_GET['year'] : date("Y");
            if($year == "") $year = date("Y");
            $quater_current = ceil(date("n") / 3);
            $quater =  $quater_current - 1;
            if($quater == 0){
                $quater = 4;
                $year = $year -1;
            }
            if(array_key_exists('quater', $_GET)){
                $quater = $_GET['quater'] != "" ? $_GET['quater'] : $quater;
            }
            //$quater = array_key_exists('quater', $_GET) ? $_GET['quater'] : $quater;
            $years = range(2022, date("Y"));
            
            $m = (($quater * 3)-3) + 1; // start month
            $from = date("Y-m-d", mktime(0, 0, 1, $m, 1, $year));
            $m = (($quater * 3)-3) + 3; // end month
            $to = date("Y-m-d", mktime(0, 0, 1, $m, 1, $year));
        }

        $districts = get_posts([
            'post_type' => 'learnpress_district',
            'numberposts' => -1,
             'order'    => 'ASC'
        ]);
        $district_id = array_key_exists('district', $_GET) ? $_GET['district'] :  $districts[0]->ID;

		$this->items = getTeamData($from, $to, $district_id);

        $columns = $this->get_columns();
        $hidden = array();
        $sortable = array();

        $this->_column_headers = array($columns, $hidden, $sortable);

		
    }
}