<?php
/**
 * LearnPress Admin Page Overview
 *
 * Define common functions for both front-end and back-end
 *
 * @author   ThimPress
 * @package  LearnPress/Wishlist/Functions
 * @version  3.0.0
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;

require_once  LP_ADDON_LEARNDOREPORTS_INC . 'data/data-courses.php';

if (!class_exists('WP_List_Table')) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

function learndo_reports_add_menu_item_courses() {
    add_submenu_page('learndo-reports', 'Courses', 'Courses', 'activate_plugins', 'learndo-reports-courses', 'learndo_reports_render_courses', 1);
}
add_action('admin_menu', 'learndo_reports_add_menu_item_courses');


function learndo_reports_render_courses() {
	?>
	
		<?php 
		$from = array_key_exists('from_date', $_GET) ? $_GET['from_date'] : '';
		$to = array_key_exists('to_date', $_GET) ? $_GET['to_date'] : date('Y-m-d');
	
		//Create an instance of our package class...
		$coursesTable = new LearnDo_Reports_Courses_Table();
		//Fetch, prepare, sort, and filter our data...
		$coursesTable->prepare_items();
		?>
		<div class="wrap">
	
			<div id="icon-users" class="icon32"><br/></div>
			<h2>LearnDo Reports - Courses</h2>
			
			<form action="<?= esc_url(admin_url('admin.php')) ?>">
				<input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />
				<input type="date" name="from_date" value="<?= $from ?>" />
				<input type="date" name="to_date" value="<?= $to ?>" />
				<input type="submit" value="Show" class="e-button" />

				<a href="<?= esc_url(admin_url('admin.php')) . "?page=" .  $_REQUEST['page'] . "&from_date=&to_date=" . date('Y-m-d') ?>" class="button">All Time</a>
				<a href="<?= esc_url(admin_url('admin.php')) . "?page=" .  $_REQUEST['page'] . "&from_date=" . date("Y-m-d", mktime(0, 0, 0, date("m")-1, 1)) . "&to_date=" . date("Y-m-d", mktime(0, 0, 0, date("m"), 0)) ?>" class="button">Last Month</a>
				<a href="<?= esc_url(admin_url('admin.php')) . "?page=" .  $_REQUEST['page'] . "&from_date=" . date("Y-m-d", mktime(0, 0, 0, date("m"), 1)) . "&to_date=" . date('Y-m-d') ?>" class="button">Current Month</a>

            <?php
		$values = array();
		foreach($coursesTable->items as $item){
			$title = "#" . (string)$item["id"];
			$values[$title] = intval($item["single_purchase"]) ;
		} 
		/* ?> <pre> <?php var_dump($values); ?> </pre> <?php */
		
		$file_name = "courses_$from-$to.png";
		$queries = array(
			"from" => $from,
			"to"	=> $to,
			"values" => $values,
            "filename" => $file_name
		);
		
		$queryString = http_build_query($queries);
        $graph_url = plugin_dir_url( __FILE__ ) . "../graphs/bar_graph.php?" . $queryString;
        
        $graph_href =plugin_dir_url( dirname( dirname(__FILE__) )) . "/inc/graphs/export/" . $file_name;
		?>
            <a class="button alignright" href="<?=  plugin_dir_url( __FILE__ ) . "../pdf/pdf-overview.php?img1=". $graph_href . "&from=$from&to=$to" ?>" target="_blank">pdf download</a>


			<?php // Create CSV
        $csv_href = plugin_dir_url( dirname( dirname(__FILE__) )) . "/inc/csv/course.csv";
        $f = fopen(LP_ADDON_LEARNDOREPORTS_INC . "/csv/course.csv", "wa+");
        fputcsv($f, str_replace("title","$from - $to", array_keys($coursesTable->items[0])));
        foreach ($coursesTable->items as $row)
        {
            fputcsv($f, array_map("html_entity_decode",preg_replace("/<.+>/sU", "", $row)));
        }
        fclose($f);
        ?><a class="button alignright"  href="<?= $csv_href ?>" target="_blank">CSV download</a>
		
</form>
		<img src="<?php echo  $graph_url  ?>" style="width:100%" />
	
			<!-- Forms are NOT created automatically, so you need to wrap the table in one to use features like bulk actions -->
			<form id="movies-filter" method="get">
				<!-- For plugins, we also need to ensure that the form posts back to our current page -->
				<input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />
				<!-- Now we can render the completed list table -->
		<?php $coursesTable->display() ?>
		

		<?php $total = 0;
		foreach($coursesTable->items as $item){
			$total += $item["float_revenue"];
		} ?>
		<h2 class="alignright">Total: <?php echo wc_price($total) ?> </h2>
			</form>
	
		</div>
		<?php }

class LearnDo_Reports_Courses_Table extends WP_List_Table {

    function __construct() {
        global $status, $page;

        //Set parent defaults
        parent::__construct(array(
            'singular' => 'Nice Link', //singular name of the listed records
            'plural' => 'Nice Links', //plural name of the listed records
            'ajax' => false        //does this table support ajax?
        ));
    }

    function column_default($item, $column_name) {
        switch ($column_name) {
            case 'course': return "<b>" . $item["course"] . "</b>";
            case 'single_purchase': return $item["single_purchase"];
			case 'course_started': return $item["course_started"];
			case 'course_subscriber_completed': return $item["course_subscriber_completed"];
			case 'course_completed': return $item["course_completed"];
			case 'revenue': return $item["revenue"];
            default:
                return "col name = $column_name , " . print_r($item, true); //Show the whole array for troubleshooting purposes
        }
    }

    function get_columns() {
        return $columns = array(
            'course' => 'Course',
            'single_purchase' => __('Single-Course Purchase'),
            'course_started' => __('Total Courses Started'),
			'course_subscriber_completed' => __('Subscriber Coures Completed  '),
			'course_completed' => __('Total Courses Completed'),
            'revenue' => __('Revenue')
        );
    }
  
	function prepare_items() {

		$from = array_key_exists('from_date', $_GET) ? $_GET['from_date'] : '';
		$to = array_key_exists('to_date', $_GET) ? $_GET['to_date'] : date('Y-m-d');

		$this->items = getCoursesData($from, $to);

        $columns = $this->get_columns();
        $hidden = array();
        $sortable = array();

        $this->_column_headers = array($columns, $hidden, $sortable);

		
    }
}