<?php


class WP_Send_Report_Process extends WP_Background_Process
{

    use WP_District_Send_Report;

    /**
     * @var string
     */
    protected $action = 'district_send_report_action';

    /**
     * Task
     *
     * Override this method to perform any actions required on each
     * queue item. Return the modified item for further processing
     * in the next pass through. Or, return false to remove the
     * item from the queue.
     *
     * @param mixed $item Queue item to iterate over
     *
     * @return mixed
     */
    protected function task($item)
    {

        var_dump($item);
        file_put_contents(WP_PLUGIN_DIR . 'log_' . date("j.n.Y") . '.log', "$item " . date("j.n.Y") . "\n", FILE_APPEND);

        $this->send_report($item);

        return false;
    }

    /**
     * Complete
     *
     * Override if applicable, but ensure that the below actions are
     * performed, or, call parent::complete().
     */
    protected function complete()
    {
        file_put_contents(WP_PLUGIN_DIR . 'log_' . date("j.n.Y") . '.log', "$item " . date("j.n.Y") . "\n", FILE_APPEND);

        parent::complete();

        // Show notice to user or perform some other arbitrary task...
    }
}
