<?php
/**
 * LearnPress District Functions
 *
 * Define common functions for both front-end and back-end
 *
 * @author   ThimPress
 * @package  LearnPress/Wishlist/Functions
 * @version  3.0.0
 */

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'learn_press_district_template' ) ) {
	/**
	 * Get pmpro account template.
	 *
	 * @param      $name
	 * @param null $args
	 */
	function learn_press_district_template( $name, $args = null ) {
		LP_Addon_District::instance()->get_template( $name, $args );
		//learn_press_get_template( $name, $args, learn_press_template_path() . '/addons/wishlist/', LP_ADDON_WISHLIST_TEMPLATE );
	}
}



add_filter( 'learn_press_profile_tabs', 'learn_press_District', 20, 2 );
if ( ! function_exists( 'learn_press_District' ) ) {
	/**
	 *  Add pmpro account tab into profile page.
	 *
	 * @param $tabs
	 * @param $user
	 *
	 * @return mixed
	 */
	function learn_press_District( $tabs, $user ) {
		$content = '';

		$tabs[40] = array(
			'tab_id'      => 'District',
			'tab_name'    => __( 'District', 'learnpress_district' ),
			'tab_content' => apply_filters( 'learn_press_user_District_content', $content, $user )
		);
		// Private customize
		if ( $user->ID != get_current_user_id() ) {
			unset ( $tabs[40] );
		}

		return $tabs;
	}
}


