<?php

/**
 * LearnPress Admin Page Overview
 *
 * Define common functions for both front-end and back-end
 *
 * @author   ThimPress
 * @package  LearnPress/Wishlist/Functions
 * @version  3.0.0
 */

// Prevent loading this file directly
defined('ABSPATH') || exit;


if (!class_exists('WP_List_Table')) {
    require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}

function learndo_district_add_menu_item_settings()
{
    add_submenu_page('learndo-district', 'Settings', 'Settings', 'activate_plugins', 'learndo-district-settings', 'learndo_district_render_district_settings', 250);
}
add_action('admin_menu', 'learndo_district_add_menu_item_settings');


function learndo_district_render_district_settings()
{
    //district_sendreport_cron_job_run();

    ?>
    <h1>Create Districts</h1>
   
<?php
    if (array_key_exists('create_all', $_GET)) :

        global $wpdb; //This is used only if making any database queries

        $users = $wpdb->get_results("
            SELECT u.ID, u.user_email,u.display_name as user_name, um.meta_value as lea_name
            FROM `wp_users` as u
            LEFT JOIN wp_usermeta AS um
            ON u.ID = um.user_id 
            WHERE um.meta_key = 'lea_name'
            AND um.meta_value != ''
        ;");

        $new_districts = array();
        foreach ($users as $user) {
            $district = $wpdb->get_results("
                SELECT * FROM wp_postmeta
                WHERE meta_key = 'lea_name' AND  meta_value = '" . $user->lea_name ."' 
                ;" );
           
            if (count($district) > 0) {
                //echo var_dump( reset($district)->post_id);
                // district exists
                update_user_meta($user->ID, 'district_id', reset($district)->post_id);
            } else {
                // ditrict not found: create
                $new_districts[$user->lea_name][] = $user->ID;
            }
        }

        /* ?> <pre> <?php var_dump($new_districts) ?> </pre> <?php */

        foreach ($new_districts as $key => $users) {
            echo  $key . "(" .  count($users) .")" . '<br>';
            // Gather post data.
            $new_district = array(
                'post_type'     => 'learnpress_district',
                'post_title'    => $key,
                'post_content'  => '',
                'post_status'   => 'publish',
                'post_author'   => 1,
                'meta_input'   => array(
                    'lea_name' => $key,
                ),
            );

            // Insert the post into the database.
            $new_district_id = wp_insert_post($new_district);

            foreach ($users as $user) {
                //echo $user . '<br>';
                update_user_meta($user, 'district_id', $new_district_id);
            }
        }
        echo 'all imported';

    else :
?> <form action="<?= esc_url(admin_url('admin.php')) ?>">
            <input type="hidden" name="page" value="<?php echo $_REQUEST['page'] ?>" />
            <input type="hidden" name="create_all" value="1" />
            <h3>Create all District and asign users based on the lea name</h3>
            <button type="submit" class="button" value="">Create all districts from Users LEA</button>
        </form>
    <?php endif ?>
    <br />
    <hr />
    <h1>Settings</h1>
    <form method="POST" action="options.php">
        <?php settings_fields( 'learndo-district-settings' ); 
        do_settings_sections( 'learndo-district-settings' );
        ?>
        <br /><br />
        <?php submit_button(); ?>
    </form>
<?php
}

//add_action( 'admin_init', 'learndo_district_setting_init' );

function learndo_district_setting_init() {

    add_settings_section(
        'sample_page_setting_section',
        __( 'District Settings', 'my-textdomain' ),
        'my_setting_section_callback_function',
        'learndo-district-settings'
    );

		add_settings_field(
		   'district_mail_setting_field',
		   __( 'Send Mail Interval', 'my-textdomain' ),
		   'district_setting_markup',
		   'learndo-district-settings',
		   'sample_page_setting_section'
		);

        register_setting( 'learndo-district-settings', 'district_reports_mail_date' );
		register_setting( 'learndo-district-settings', 'district_reports_interval' );
}


function my_setting_section_callback_function() {
    echo '<p>All Settings for LearnDo District Manager</p>';
}


function district_setting_markup() {
    ?>
    <label for="district_reports_interval"><?php _e( 'Interval' ); ?></label>
    <input type="text" id="district_reports_interval" name="district_reports_interval" value="<?php echo get_option( 'district_reports_interval' ); ?>">
    
    <label for="district_reports_mail_date">Send Date</label>
    <input type="date" id="district_reports_mail_date" name="district_reports_mail_date" value="<?php echo get_option( 'district_reports_mail_date' ); ?>">
    <?php
}
