<?php

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;


require_once  LP_ADDON_DISTRICT_INC . 'admin/meta-boxes/lea-box.php';
require_once  LP_ADDON_DISTRICT_INC . 'admin/meta-boxes/add-user-box.php';
require_once  LP_ADDON_DISTRICT_INC . 'admin/meta-boxes/users-box.php';
require_once  LP_ADDON_DISTRICT_INC . 'admin/meta-boxes/director-box.php';


function district_register_post_type() {

	$labels = array(
		'name' => __( 'Districts', 'learnpress_district' ),
		'singular_name' => __( 'District', 'learnpress_district' ),
		'add_new' => __( 'New District', 'learnpress_district' ),
		'add_new_item' => __( 'Add New District', 'learnpress_district' ),
		'edit_item' => __( 'Edit District', 'learnpress_district' ),
		'new_item' => __( 'New District', 'learnpress_district' ),
		'view_item' => __( 'View Districts', 'learnpress_district' ),
		'search_items' => __( 'Search Districts', 'learnpress_district' ),
		'not_found' =>  __( 'No Districts Found', 'learnpress_district' ),
		'not_found_in_trash' => __( 'No Districts found in Trash', 'learnpress_district' ),
	   );
   
	register_post_type('learnpress_district',
		array(
			'labels'      => $labels,
			'public'      => true,
			'has_archive' => false,
			'rewrite'     => array( 'slug' => 'district' ), // my custom slug
			'menu_icon'   => 'dashicons-admin-multisite',
            'show_in_menu' => 'learndo-district',
			'register_meta_box_cb' => 'lea_name_meta_box',
			'supports' => array(
					'title',
					'editor',
					'users',
					'lea-name',
					'add-user',
					'director'
				), 
		)
	);
}

add_action( 'init', 'district_register_post_type' );


function learndo_district_add_menu_item_main() {
    add_menu_page('LearnDo District', 'LearnDo District', 'activate_plugins', 'learndo-district', 'learndo_district_render_overview', 'dashicons-admin-multisite', 4);
}

add_action('admin_menu', 'learndo_district_add_menu_item_main');


function learndo_district_render_overview() {

}

