<?php


function add_user_meta_box() {

$screens = array( 'learnpress_district' );

foreach ( $screens as $screen ) {
    add_meta_box(
        'add-user',
        __( 'Add user', 'learnpress_district' ),
        'add_user_meta_box_callback',
        $screen
    );
}
}

function add_user_meta_box_callback( $post ) {

// Add a nonce field so we can check for it later.
wp_nonce_field( 'add_user_nonce', 'add_user_nonce' );

$value = get_post_meta( $post->ID, 'add_user', true );

echo '<input type="text" style="" id="add_user" name="add_user" value="' . esc_attr( $value ) . '"/>';
echo '<input class="button" type="submit" value="Add" />';

}

/**
*  LEA META BOX
* set the lea name of the district
* 
*/


add_action( 'add_meta_boxes', 'add_user_meta_box' );

/**
* When the post is saved, saves our custom data.
*
* @param int $post_id
*/
function save_add_user_meta_box_data( $post_id ) {

// Check if our nonce is set.
if ( ! isset( $_POST['add_user_nonce'] ) ) {
    return;
}

// Verify that the nonce is valid.
if ( ! wp_verify_nonce( $_POST['add_user_nonce'], 'add_user_nonce' ) ) {
    return;
}

// If this is an autosave, our form has not been submitted, so we don't want to do anything.
if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
    return;
}

// Check the user's permissions.
if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {

    if ( ! current_user_can( 'edit_page', $post_id ) ) {
        return;
    }

}
else {

    if ( ! current_user_can( 'edit_post', $post_id ) ) {
        return;
    }
}

/* OK, it's safe for us to save the data now. */

// Make sure that it is set.
if ( ! isset( $_POST['add_user'] ) ) {
    return;
}

// Sanitize user input.
$my_data = sanitize_text_field( $_POST['add_user'] );
if($my_data != ""){
    //$my_data = str_replace('*','%', $my_data);
    $users = get_users( array(  'search' => $my_data ) );

    $added_users = array();
    foreach ($users as $user){
        $user_id = $user->ID;
        update_user_meta( $user_id, 'district_id',  $post_id );
        $added_users[] = $user->ID;
    }

    if(count($added_users) > 0) {
        AdminNotice::displaySuccess(__('User added: ' . implode(',', $added_users)));
    } else {
        AdminNotice::displayError(__('User not found:' . $my_data ));
    }
}

/* $user = get_user_by('email', $my_data);
if($user){
    $user_id = $user->ID;
    update_user_meta( $user_id, 'district_id',  $post_id );
    AdminNotice::displaySuccess(__('User added: ' . $my_data));
    return "added";
} else {
    AdminNotice::displayError(__('User not found:' . $my_data ));
} */



// Update the meta field in the database.
 //update_post_meta( $post_id, 'add_user', $my_data );
}

add_action( 'save_post', 'save_add_user_meta_box_data' );

add_action('admin_notices', [new AdminNotice(), 'displayAdminNotice']);

