<?php

/**
 * Import Users from CSV Learnpress
 *
 * @package       IMPORTUSERLP
 * @author        Benjamin Albrecht
 * @version       1.0.0
 *
 * @wordpress-plugin
 * Plugin Name:   Import Users from CSV Learnpress
 * Plugin URI:    https://albrightdesign.de
 * Description:   Extenend import users from csv with learnpress and membership pro, create an woo and lp order on import
 * Version:       1.0.0
 * Author:        Benjamin Albrecht
 * Author URI:    https://albrightdesign.de
 * Text Domain:   import-userser-from-csv-lp
 * Domain Path:   /languages
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;


add_filter('is_iu_userdata_fields', 'add_fields_to_csv', 10, 1);
add_action('is_iu_post_user_import', 'process_post_import', 10, 3);
add_action('is_iu_import_page_after_form', 'lp_generate_ids_csv');


/**
 *  Add fields to import from the csv
 * 
 * @since 1.0.0
 * 
 * @return array csv fields to import
 */
function add_fields_to_csv($userdata_fields)
{
    array_push($userdata_fields, "membership_level", "membership_expire_date", "courses", "downloadables", "lea_name");
    return $userdata_fields;
}

/**
 *  Genrate Orders for Woocomerce and Learnpress
 * 
 * @since 1.0.0
 * 
 * @return null
 */

function process_post_import($user_id, $userdata, $usermeta)
{

    // add membership if set in the import data
    if (!empty($userdata['membership_level'])) {
        $membership_level = $userdata['membership_level'];
        if ($membership_level == 'cancel') {
            pmpro_changeMembershipLevel(null, $user_id);
        } else {
            pmpro_changeMembershipLevel($membership_level, $user_id);
        
            if (!empty($userdata['membership_expire_date'])) {
                //update the expiration date
                $expiration_date = $userdata['membership_expire_date']; // 2024-12-01  Y-M-D
                global $wpdb;
                $sqlQuery = "UPDATE $wpdb->pmpro_memberships_users SET enddate = '" . $expiration_date . "' WHERE status = 'active' AND membership_id = '" . $membership_level . "' AND user_id = '" . $user_id . "' LIMIT 1";
                if($wpdb->query($sqlQuery))
                    $expiration_changed = true;
            }
        }
    }

    if (!empty($userdata['downloadables'])) {
        try {
            $order = wc_create_order();

            // add all downloadables to the order
            $downloadables = explode(",", $userdata['downloadables']);
            foreach ($downloadables as $downloadableId) {
                $order->add_product(wc_get_product($downloadableId), 1, array('subtotal' => 0, 'total' => 0));
            }

            $order->set_customer_id($user_id);
            $order->set_status('completed', 'imported order');
            $order->calculate_totals();
            $order->save();

            // update download permissions
            wc_downloadable_product_permissions($order->get_id());

            //csvlpimport_log("order id: " . $order->get_id());

        } catch (Exception $e) {
            csvlpimport_log('downloadables error: ', $user_id,  $e->getMessage());
        }
    }

    if (!empty($userdata['courses'])) {

        try {
            // Learnpress new order
            $courses = explode(",", $userdata['courses']);
            $lp_order = array('post_type' => 'lp_order');
            $post_id = wp_insert_post($lp_order); // Create new order in LearnPress orders
            $lp_order    = learn_press_get_order($post_id);
            $order_item_ids = $lp_order->add_items($courses); //add courses to the order

            $lp_order->set_user_id($user_id); // User into the course
            $lp_order->set_status('lp-completed');
            // Setorder as paid and complete you can use status based on your requirements
            $lp_order->save();
        } catch (Exception $e) {
            csvlpimport_log('course error: ', $user_id,  $e->getMessage());
        }
    }

    // set the lea_name if not empty
    if (!empty($userdata['lea_name'])) {
        update_user_meta( $user_id, 'lea_name', sanitize_text_field( $userdata['lea_name'] ) );

        // try find the district id and asign
        $args = array(
            'lea_name' =>  $userdata['lea_name'],
            'post_type' => 'learnpress_district'
            );
            $query = new WP_Query( $args );
            if ($query->have_posts()) {
                $district = $query->posts[0];
                update_user_meta( $user_id, 'district_id', $district->ID );
              }


    }

    // set user meta as imported
    update_user_meta( $user_id, 'user_imported',  true);

    // set user meta welcome not send (no welcome email send)
    $welcome_not_send = get_user_meta( $user_id, 'welcome_not_send', true );

    if($welcome_not_send == ''){
        update_user_meta( $user_id, 'welcome_not_send',  true);
    }    
}


/**
 * Write an entry to a log file in the uploads directory.
 * 
 * @since 1.0.0
 * 
 * @param mixed $entry String or array of the information to write to the log.
 * @param string $file Optional. The file basename for the .log file.
 * @param string $mode Optional. The type of write. See 'mode' at https://www.php.net/manual/en/function.fopen.php.
 * @return boolean|int Number of bytes written to the lof file, false otherwise.
 */
if (!function_exists('csvlpimport_log')) {
    function csvlpimport_log($entry, $mode = 'a', $file = 'import_users_csv_lp')
    {
        // Get WordPress uploads directory.
        $upload_dir = wp_upload_dir();
        $upload_dir = $upload_dir['basedir'];
        // If the entry is array, json_encode.
        if (is_array($entry)) {
            $entry = json_encode($entry);
        }
        // Write the log file.
        $file  = $upload_dir . '/' . $file . '.log';
        $file  = fopen($file, $mode);
        $bytes = fwrite($file, current_time('mysql') . "::" . $entry . "\n");
        fclose($file);
        return $bytes;
    }
}

/**
 * Create a form for the backend to generate the post-ids csv
 * 
 * @since 1.0.0
 * 
 * @return string|html 
 */

function lp_generate_ids_csv()
{
    if (isset($_POST['_wpnonce-lp_generate_ids_csv'])) {
        export_post_ids("lp_course");
        export_post_ids("product");
        echo 'csv generated';
    } else {

        echo '
        <form method="post" action="" enctype="multipart/form-data">
                ' . wp_nonce_field('lp_generate_ids_csv', '_wpnonce-lp_generate_ids_csv') . '

            <h3>Generate Course and Downloadables Ids</h3>
            <p>saved to /wp-content/uploads/export </p>
            <input type="submit" class="button-secondary" value="Generate Ids CSV" />
        </form>
        ';
    }
}

/**
 * Generate a CSV with id and title of given post type
 * 
 * @since 1.0.0
 * 
 * @param string $post_type the type of the post to export id and title to csv
 * @return boolean|int Number of bytes written to the lof file, false otherwise. 
 */
if (!function_exists('export_post_ids')) {
    function export_post_ids($post_type = "lp_course")
    {

        $file = 'export_ids_' . $post_type;

        $posts = get_posts([
            'post_type' => $post_type,
            'post_status' => 'publish',
            'numberposts' => -1
            // 'order'    => 'ASC'
        ]);

        $entry = "ID;Title\n";

        foreach ($posts as $post) {
            $entry .= $post->ID . ';' . get_the_title($post) . "\n";
        }

        // Get WordPress uploads directory.
        $upload_dir = wp_upload_dir();
        $upload_dir = $upload_dir['basedir'] . '/export';

        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0755, true); // true for recursive create
        }

        // If the entry is array, json_encode.
        if (is_array($entry)) {
            $entry = json_encode($entry);
        }
        // Write the log file.
        $file  = $upload_dir . '/' . $file . '.csv';
        $file  = fopen($file, 'wa+');
        $bytes = fwrite($file, $entry . "\n");
        fclose($file);
        return $bytes;
    }
}

// add field for lea_name
add_action( 'show_user_profile', 'learndo_custom_user_fields' );
add_action( 'edit_user_profile', 'learndo_custom_user_fields' );

function learndo_custom_user_fields( $user ) {

	$lea_name = get_user_meta( $user->ID, 'lea_name', true );
    $district_id = get_user_meta( $user->ID, 'district_id', true );
    $user_imported = get_user_meta( $user->ID, 'user_imported', true );
    $welcome_not_send = get_user_meta( $user->ID, 'welcome_not_send', true );

	?>
		<h3>Learn.Do Additional Information</h3>
		<table class="form-table">
        <tr>
			<th><label for="district_id">District</label></th>
		 		<td>
					<input type="text" name="district_id" id="district_id" value="<?php echo esc_attr( $district_id ) ?>" class="regular-text" />
				</td>
			</tr>
	 		<tr>
				<th><label for="lea_name">LEA Name</label></th>
		 		<td>
					<input type="text" name="lea_name" id="lea_name" value="<?php echo esc_attr( $lea_name ) ?>" class="regular-text" />
				</td>
			</tr>
            <tr>
				<th><label for="user_imported">Imported</label></th>
		 		<td>
					<input type="checkbox" name="user_imported" id="user_imported" <?php if($user_imported):?> checked="checked" <?php endif ?> class="regular-text" />
				</td>
			</tr>
            <tr>
				<th><label for="welcome_not_send">Welcome not send</label></th>
		 		<td>
					<input type="checkbox" name="welcome_not_send" id="welcome_not_send" <?php if($welcome_not_send):?> checked="checked" <?php endif ?> class="regular-text" />
				</td>
			</tr>            
		</table>
	<?php
}

add_action( 'personal_options_update', 'learndo_save_custom_user_fields' );
add_action( 'edit_user_profile_update', 'learndo_save_custom_user_fields' );
 
function learndo_save_custom_user_fields( $user_id ) {
	
	if( ! isset( $_POST[ '_wpnonce' ] ) || ! wp_verify_nonce( $_POST[ '_wpnonce' ], 'update-user_' . $user_id ) ) {
		return;
	}
	
	if( ! current_user_can( 'edit_user', $user_id ) ) {
		return;
	}
 
	update_user_meta( $user_id, 'lea_name', sanitize_text_field( $_POST[ 'lea_name' ] ) );
    update_user_meta( $user_id, 'user_imported', $_POST[ 'user_imported' ] );
    update_user_meta( $user_id, 'welcome_not_send', $_POST[ 'welcome_not_send' ] );
    update_user_meta( $user_id, 'district_id', $_POST[ 'district_id' ] );
 
}

function mysite_columns($defaults) {
    $defaults[('lea_name')] = 'LEA Name';
    $defaults[('user_imported')] = 'Imported';
    $defaults[('welcome_not_send')] = 'Welcome not send';
    return $defaults;
  }
  
  function mysite_custom_columns($value, $column_name, $id) {
    if( $column_name == 'lea_name' ) {
        return get_the_author_meta('lea_name', $id );
    }

    if( $column_name == 'user_imported' ) {
        return get_the_author_meta('user_imported', $id );
    }

    if( $column_name == 'welcome_not_send' ) {
        return get_the_author_meta('welcome_not_send', $id );
    }

    return $value;
  }

add_action('manage_users_custom_column', 'mysite_custom_columns', 15, 3);
add_filter('manage_users_columns', 'mysite_columns', 15, 1);

//remove column “post” from user page
add_action('manage_users_columns','remove_user_posts_column');
function remove_user_posts_column($column_headers) {
    unset($column_headers['posts']);
    return $column_headers;
}

//make the new column sortable
function user_sortable_columns( $columns ) {
    $columns['lea_name'] = 'lea_name';
    $columns['user_imported'] = 'user_imported';
    $columns['welcome_not_send'] = 'welcome_not_send';
    return $columns;
}

add_filter( 'manage_users_sortable_columns', 'user_sortable_columns' );
 
//set instructions on how to sort the new column
if(is_admin()) {//prolly not necessary, but I do want to be sure this only runs within the admin
    add_action('pre_user_query', 'my_user_query', 10, 1);
}
function my_user_query($userquery){
    if('lea_name'==$userquery->query_vars['orderby']) {//check if church is the column being sorted
        global $wpdb;
        $userquery->query_from .= " LEFT OUTER JOIN $wpdb->usermeta AS alias ON ($wpdb->users.ID = alias.user_id) ";//note use of alias
        $userquery->query_where .= " AND alias.meta_key = 'lea_name' ";//which meta are we sorting with?
        $userquery->query_orderby = " ORDER BY alias.meta_value ".($userquery->query_vars["order"] == "ASC" ? "asc " : "desc ");//set sort order
    }

    if('user_imported'==$userquery->query_vars['orderby']) {//check if church is the column being sorted
        global $wpdb;
        $userquery->query_from .= " LEFT OUTER JOIN $wpdb->usermeta AS alias ON ($wpdb->users.ID = alias.user_id) ";//note use of alias
        $userquery->query_where .= " AND alias.meta_key = 'user_imported' ";//which meta are we sorting with?
        $userquery->query_orderby = " ORDER BY alias.meta_value ".($userquery->query_vars["order"] == "ASC" ? "asc " : "desc ");//set sort order
    }

    if('welcome_not_send'==$userquery->query_vars['orderby']) {//check if church is the column being sorted
        global $wpdb;
        $userquery->query_from .= " LEFT OUTER JOIN $wpdb->usermeta AS alias ON ($wpdb->users.ID = alias.user_id) ";//note use of alias
        $userquery->query_where .= " AND alias.meta_key = 'welcome_not_send' ";//which meta are we sorting with?
        $userquery->query_orderby = " ORDER BY alias.meta_value ".($userquery->query_vars["order"] == "ASC" ? "asc " : "desc ");//set sort order
    }

    global $wpdb;
    
        $search = '';
        if ( isset( $userquery->query_vars['search'] ) )
            $search = trim( $userquery->query_vars['search'] );
    
        if ( $search ) {
            $search = trim($search, '*');
            $the_search = '%'.$search.'%';
    
            $search_meta = $wpdb->prepare("
            ID IN ( SELECT user_id FROM {$wpdb->usermeta}
            WHERE ( ( meta_key='first_name' OR meta_key='last_name' OR meta_key='email' OR meta_key='lea_name' )
                AND {$wpdb->usermeta}.meta_value LIKE '%s' )
            )", $the_search);
    
            $userquery->query_where = str_replace(
                'WHERE 1=1 AND (',
                "WHERE 1=1 AND (" . $search_meta . " OR ",
                $userquery->query_where );
     }
}
